// Require necessary packages
const express = require("express");
const mongoose = require('mongoose');
const cors = require('cors');
const userRouter = require("./src/routes/user.route.js");
const cookieParser = require("cookie-parser");
require('dotenv').config();

// Connect to MongoDB
mongoose.connect(process.env.MONGODB_URI, {
  useNewUrlParser: true,
  useUnifiedTopology: true,
})
  .then(() => {
    console.log("Connected to MongoDB");
  })
  .catch((err) => {
    console.log("Failed to connect to MongoDB", err);
  });

// Initialize Express app
const app = express();
app.use(express.json());
app.use(cookieParser());
app.use(cors({
  origin: 'https://anchoragetrustee.com',  
  credentials: true,
}));



// Set up server
app.listen(4000, () => {
  console.log("Server is running on port 4000");
});

// Routes
app.use("/api/user", userRouter);


// Global error handling middleware
app.use((err, req, res, next) => {
  const statusCode = err.statusCode || 500;
  const message = err.message || "Internal Server Error";
  return res.status(statusCode).json({
    success: false,
    statusCode,
    message,
  });
});
