// const cloudinary = require("cloudinary").v2;
// const multer = require("multer");

// cloudinary.config({
//   cloud_name: "dtdahmi9v",
//   api_key: "121314651965744",
//   api_secret: "IIeFpx53ZYH_EgIg_Moj2UeZ_iE",
// });

// const storage = new multer.memoryStorage();

// async function imageUploadUtil(file) {
//   const result = await cloudinary.uploader.upload(file, {
//     resource_type: "auto",
//   });

//   return result;
// }

// const upload = multer({ storage });

// module.exports = { upload, imageUploadUtil };


// Assuming this is inside your imageUploadUtil function
const cloudinary = require('cloudinary').v2;

cloudinary.config({
  cloud_name: process.env.CLOUDINARY_CLOUD_NAME,
  api_key: process.env.CLOUDINARY_API_KEY,
  api_secret: process.env.CLOUDINARY_API_SECRET,
});

async function imageUploadUtil(fileBuffer) {
    return new Promise((resolve, reject) => {
      const uploadStream = cloudinary.uploader.upload_stream(
        { resource_type: 'auto' },  // automatically detects file type
        (error, result) => {
          if (error) {
            return reject(error); // Reject the promise if there's an error
          }
          resolve(result); // Resolve the promise with the Cloudinary result
        }
      );
  
      // Pipe the file buffer to Cloudinary
      uploadStream.end(fileBuffer);
    });
}

module.exports = {  imageUploadUtil };

