const mongoose = require('mongoose');
const { Schema } = mongoose;

const generateUniqueKYC = async () => {
  const prefixes = ["30", "10", "00"];

  while (true) {
    const prefix = prefixes[Math.floor(Math.random() * prefixes.length)];
    const randomNumber = Math.floor(Math.random() * 100000000)
      .toString()
      .padStart(8, "0");

    const kycCode = prefix + randomNumber;

    // Check uniqueness safely
    const exists = await mongoose.models.User.findOne({
      KYC_Verification_Code: kycCode,
    });

    if (!exists) {
      return kycCode;
    }
  }
};


const userSchema = new Schema({
  firstName: {
    type: String,
    required: true,
  },
  lastName: {
    type: String,
    required: true,
  },
  email: {
    type: String,
    required: true,
    unique: true,
    lowercase: true,
    trim: true,
    match: [/.+@.+\..+/, 'Please enter a valid email address'],
  },
  phone: {
    type: String,
    required: true,
  },
  country: {
    type: String,
    required: true,
  },
  address: {
    type: String,
    required: true,
  },
  city: {
    type: String,
    required: true,
  },
  state: {
    type: String,
    required: true,
  },
  postalCode: {
    type: String,
    required: true,
  },
  dateOfBirth: {
    type: String,
    required: true,
  },
  otp: {
    type: String,
    required: true,
  },
  loginCode: {
    type: String,
    required: true,
  },
  password: {
    type: String,
    required: true,
  },
  idType: {
    type: String,
    required: true,
  },
  idNumber: {
    type: String,
    required: true,
  },
  idFile: {
    type: String,
    required: true,
  },
  verificationPhoto: {
    type: String,
    required: true,
  },
  admin: {
    type: Boolean,
    default: false,
  },
  KYC_Verification_Code: {
    type: String,
    unique: true,
  },

  kycStatus: {
    type: String,
    enum: ["pending", "approved", "rejected"],
    default: "pending",
  },
  showKYC_code: {
    type: Boolean,
    default: false,
  },
  avatar: {
    type: String,
    default: 'https://static.vecteezy.com/system/resources/previews/005/950/866/original/male-avatar-with-coins-investor-icon-vector.jpg',
  },
}, { timestamps: true });

// Generate a unique account number before saving the user
userSchema.pre('save', async function (next) {
  if (!this.KYC_Verification_Code) {
    this.KYC_Verification_Code = await generateUniqueKYC();
  }
  next();
});

const User = mongoose.model('User', userSchema);

module.exports = User;
