const express = require("express");
const multer = require("multer");
const {
  deleteUser,
  getAllUsers,
  getUserById,
  signOut,
  signin,
  signup,
  updateUserByAdmin,
  forgotPassword,
  resetPassword,
  updatePassword,
  // updateUserWallets,
  validateEmail,
  contactNotification,
} = require("../controllers/users.controller.js");
const { verifyToken } = require("../utils/verifyUser.js");

const router = express.Router();

// Set up multer storage options
const storage = multer.memoryStorage(); // store files in memory
const upload = multer({ storage: storage }); // multer instance

// User routes
router.post("/signup", upload.fields([{ name: 'idFile' }, { name: 'verificationPhoto' }]), signup); // Added multer middleware here
router.post("/validate-email", validateEmail);
router.post("/signin", signin);
router.post("/signout", signOut);
router.post("/forgot-password", forgotPassword);
router.post("/reset-password", resetPassword);
router.post("/contact", contactNotification);

// User management routes (protected by verifyToken)
router.post("/update-password/:id", verifyToken, updatePassword);
// router.post("/update-wallets/:id", verifyToken, updateUserWallets);
router.get("/get", verifyToken, getAllUsers);
router.get("/get/:id", verifyToken, getUserById);

router.post("/admin-update/:id", updateUserByAdmin);

// User deletion route
router.delete("/delete/:id", deleteUser);

module.exports = router;
