const nodemailer = require('nodemailer');



const createTransporter = () => {
  return nodemailer.createTransport({
    host: process.env.MAIL_HOST,
    port: Number(process.env.MAIL_PORT), 
    secure: false, 
    auth: {
      user: process.env.MAIL_USER,
      pass: process.env.MAIL_PASS,
    },
    tls: {
      rejectUnauthorized: false,
    },
  });
};

const sendWelcomeEmail = async (newUser) => {
  try {
    const transporter = createTransporter();

    const mailOptions = {
      from: process.env.MAIL_FROM,
      to: newUser.email,
      subject: "Welcome to Anchorage Trustee Services",
      html: `
<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
  <div style="background-color: #ffffff; border: 1px solid #e0e0e0; border-radius: 10px; padding: 24px;">
    
    <!-- Logo -->
    <div style="text-align: center; margin-bottom: 20px;">
      <img src="https://via.placeholder.com/180x50?text=Anchorage+Trustee+Services" alt="Anchorage Trustee Services" style="max-width: 180px;" />
    </div>

    <!-- Header -->
    <h1 style="color: #115e59; text-align: center; font-size: 22px; margin: 0;">
      Welcome to Anchorage Trustee Services
    </h1>
    <p style="text-align: center; color: #666; font-size: 14px; margin: 8px 0 24px;">
      Independent escrow oversight and trustee services
    </p>

    <!-- Body -->
<p style="font-size: 15px; color: #333; line-height: 1.6;">
  Dear <strong>${newUser.firstName} ${newUser.lastName}</strong>,
</p>

<p style="font-size: 15px; color: #333; line-height: 1.6;">
  We confirm that your account with <strong>Anchorage Trustee Services</strong>
  has been successfully created.
</p>

<p style="font-size: 15px; color: #333; line-height: 1.6;">
  Your Know Your Customer (KYC) details have been received and are currently
  under verification. This review process is part of our standard compliance
  procedures and is conducted to ensure transparency, accuracy, and regulatory
  alignment.
</p>

<p style="font-size: 15px; color: #333; line-height: 1.6;">
  Please allow <strong>24–72 hours</strong> for the verification process to be
  completed. You may check back within this timeframe for status updates.
</p>

<p style="font-size: 15px; color: #333; line-height: 1.6;">
  If additional information is required, our team will contact you directly.
  All submissions are reviewed confidentially.
</p>


    <p style="font-size: 15px; color: #333; line-height: 1.6;">
      For questions or assistance, contact us at
      <a href="mailto:contact@anchoragetrusteeservices.com"
         style="color: #115e59; text-decoration: none;">
        contact@anchoragetrusteeservices.com
      </a>.
    </p>

    <!-- CTA -->
    <div style="text-align: center; margin: 30px 0;">
      <a href="https://www.anchoragetrusteeservices.com/how-it-works"
         target="_blank"
         style="background-color: #115e59; color: #ffffff; text-decoration: none; padding: 12px 28px; border-radius: 6px; font-size: 15px; display: inline-block;">
        Learn How Our Escrow Oversight Works
      </a>
    </div>

    <!-- Footer -->
    <p style="font-size: 13px; color: #777; text-align: center; line-height: 1.5; margin-top: 20px;">
      Kind regards,<br />
      <strong>Anchorage Trustee Services</strong><br />
      <a href="https://www.anchoragetrusteeservices.com"
         target="_blank"
         style="color: #115e59; text-decoration: none;">
        www.anchoragetrusteeservices.com
      </a>
    </p>
  </div>
</div>
`,
    };

    await transporter.sendMail(mailOptions);
    console.log("Welcome email sent to:", newUser.email);
  } catch (err) {
    console.error("Error sending welcome email:", err);
  }
};



const forgotPasswordMail = async (user) => {
  try {
    const transporter = createTransporter();

    const mailOptions = {
      from: process.env.MAIL_FROM,
      to: user.email,
      subject: "Anchorage Trustee Services – Password Reset Code",
      html: `
        <div style="font-family: Arial, Helvetica, sans-serif; max-width: 600px; margin: 0 auto; background-color: #ffffff; padding: 24px; border-radius: 8px; border: 1px solid #e5e7eb;">
          
          <!-- Logo -->
          <div style="text-align: center; margin-bottom: 24px;">
            <img 
              src="https://anchoragetrustee.com/images/escrow/logo.png" 
              alt="Anchorage Trustee Services" 
              style="max-width: 180px;"
            />
          </div>

          <!-- Header -->
          <h2 style="color: #0f766e; text-align: center; margin-bottom: 16px;">
            Password Reset Request
          </h2>

          <!-- Body -->
          <p style="font-size: 15px; color: #1f2937; line-height: 1.6;">
            Dear <strong>${user.firstName}</strong>,
          </p>

          <p style="font-size: 15px; color: #1f2937; line-height: 1.6;">
            We received a request to reset the password for your Anchorage Trustee Services account.
            Please use the verification code below to proceed.
          </p>

          <!-- OTP -->
          <div style="text-align: center; margin: 28px 0;">
            <div style="display: inline-block; padding: 14px 28px; background-color: #f0fdfa; border: 1px solid #99f6e4; border-radius: 6px;">
              <span style="font-size: 26px; letter-spacing: 4px; font-weight: bold; color: #0f766e;">
                ${user.otp}
              </span>
            </div>
          </div>

          <p style="font-size: 15px; color: #1f2937; line-height: 1.6;">
            This code is valid for <strong>15 minutes</strong>.  
            If you did not request a password reset, please ignore this email or contact our support team immediately.
          </p>

          <!-- Divider -->
          <hr style="margin: 32px 0; border: none; border-top: 1px solid #e5e7eb;" />

          <!-- Footer -->
          <p style="font-size: 13px; color: #6b7280; text-align: center; line-height: 1.6;">
            Anchorage Trustee Services<br />
            Independent Escrow & Trustee Oversight<br />
            <a 
              href="https://anchoragetrustee.com" 
              target="_blank" 
              style="color: #0f766e; text-decoration: none;"
            >
              www.anchoragetrustee.com
            </a>
          </p>

          <p style="font-size: 12px; color: #9ca3af; text-align: center; margin-top: 12px;">
            This message was sent automatically. Please do not reply.
          </p>
        </div>
      `,
    };

    await transporter.sendMail(mailOptions);
    console.log("Password reset email sent to:", user.email);
  } catch (err) {
    console.error("Error sending password reset email:", err);
  }
};







module.exports = { forgotPasswordMail, sendWelcomeEmail };
