const jwt = require("jsonwebtoken");
const { errorHandler } = require("./error.js");
const dotenv = require("dotenv");

// dotenv.config();

// const verifyToken = (req, res, next) => {
//   const token = req.cookies.access_token;

//   if (!token) return next(errorHandler(401, "Unauthorized"));

//   jwt.verify(token, process.env.JWT_SECRET, (err, user) => {
//     if (err) {
//       if (err.name === "TokenExpiredError") {
//         console.error("Token has expired");
//         return next(errorHandler(401, "Token has expired"));
//       }
  
//       console.error("Token verification error:", err);
//       return next(errorHandler(403, "Forbidden"));
//     }
  
//     req.user = user;
//     next();
//   });
  
// };


// module.exports = { verifyToken };


const verifyToken  = (req, res, next) => {
  const authHeader = req.headers.authorization;

  if (!authHeader || !authHeader.startsWith("Bearer ")) {
    return next(errorHandler(401, "Unauthorized"));
  }

  const token = authHeader.split(" ")[1];

  jwt.verify(token, process.env.JWT_SECRET, (err, user) => {
    if (err) return next(errorHandler(403, "Invalid token"));
    req.user = user;
    next();
  });
};

module.exports = { verifyToken };